VERSION 5.00
Begin VB.Form Form1 
   Caption         =   "Form1"
   ClientHeight    =   4845
   ClientLeft      =   3045
   ClientTop       =   1740
   ClientWidth     =   6000
   Icon            =   "frmMain.frx":0000
   LinkTopic       =   "Form1"
   ScaleHeight     =   4845
   ScaleWidth      =   6000
   Begin VB.ComboBox devNum 
      Height          =   315
      Left            =   2760
      TabIndex        =   8
      Text            =   "0"
      Top             =   840
      Width           =   615
   End
   Begin VB.Timer Timer1 
      Enabled         =   0   'False
      Left            =   3600
      Top             =   3840
   End
   Begin VB.CommandButton cmdPortB 
      Caption         =   "Walking Bit Test on Port B"
      Enabled         =   0   'False
      Height          =   375
      Left            =   360
      TabIndex        =   5
      Top             =   3000
      Width           =   2175
   End
   Begin VB.CommandButton cmdConfigure 
      Caption         =   "Configure"
      Enabled         =   0   'False
      Height          =   375
      Left            =   360
      TabIndex        =   4
      Top             =   1560
      Width           =   2175
   End
   Begin VB.CommandButton cmdReadC 
      Caption         =   "Read Port C"
      Enabled         =   0   'False
      Height          =   375
      Left            =   360
      TabIndex        =   2
      Top             =   2280
      Width           =   2175
   End
   Begin VB.CommandButton cmdClose 
      Caption         =   "Close"
      Height          =   375
      Left            =   360
      TabIndex        =   1
      Top             =   3720
      Width           =   2175
   End
   Begin VB.CommandButton cmdInit 
      Caption         =   "Initialialize"
      Height          =   375
      Left            =   360
      TabIndex        =   0
      Top             =   840
      Width           =   2175
   End
   Begin VB.Label Label5 
      Caption         =   "Port A, Port C = Input; Port B = Output"
      Height          =   375
      Left            =   2880
      TabIndex        =   10
      Top             =   1560
      Width           =   1575
   End
   Begin VB.Label Label4 
      Caption         =   "Device Number :"
      BeginProperty Font 
         Name            =   "Small Fonts"
         Size            =   6.75
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   135
      Left            =   2760
      TabIndex        =   9
      Top             =   600
      Width           =   1335
   End
   Begin VB.Label Label3 
      AutoSize        =   -1  'True
      BackColor       =   &H000000FF&
      Caption         =   "  KEITHLEY  "
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   13.5
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H8000000E&
      Height          =   360
      Left            =   360
      TabIndex        =   7
      Top             =   120
      Width           =   1845
   End
   Begin VB.Label Label2 
      BackColor       =   &H8000000E&
      Height          =   255
      Left            =   3000
      TabIndex        =   6
      Top             =   3120
      Width           =   1935
   End
   Begin VB.Label Label1 
      BackColor       =   &H8000000E&
      Height          =   375
      Left            =   2760
      TabIndex        =   3
      Top             =   2280
      Width           =   855
   End
End
Attribute VB_Name = "Form1"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit
Dim myKPCI As KPCIPIO

Private Sub cmdClose_Click()
On Error GoTo No_Board
myKPCI.CloseDevice  'if never opened, closing will raise an error
End
Exit Sub ' bypass error check section
No_Board:
End  ' close down program
End Sub

Private Sub cmdConfigure_Click()
' Direct I/O COM object implements mode 0 of Intel 8255 chip
'
' at offset of 3 is the control register
' bits of the control register dictate input or output
' direction of the Ports A, B, C hi nibble and C lo nibble
'
' bit 0 = Port C, lower 4 bits, 1 = input, 0 =  output
' bit 1 = Port B, 1 = input, 0 = output
' bit 2 = not used, always 0
' bit 3 = Port C, upper 4 bits
' bit 4 = Port A
' bits 5,6 = not used, always 0
' bit 7 = not used, ALWAYS 1
'
' for example, to make Port B an output and the other
' to be inputs, write a value of 130 (hex 82) to control register
Dim ctlRegBits(7) As Byte ' an array for the individual bits
Dim CtlReg As Byte        '
Dim i As Integer

' TODO:
' these ctlRegBits() arrays could be set equal to check box controls on the form.....
ctlRegBits(0) = 1  ' port C lower  (1 = INPUT)
ctlRegBits(1) = 0  ' Port B        (0 = OUTPUT)
ctlRegBits(2) = 0
ctlRegBits(3) = 1  ' Port C upper
ctlRegBits(4) = 1  ' Port A
ctlRegBits(5) = 0
ctlRegBits(6) = 0
ctlRegBits(7) = 1  ' most significant bit ALWAYS 1
' build the CtlReg value from the bit array
CtlReg = 0
For i = 0 To 7
CtlReg = CtlReg + ctlRegBits(i) * (2 ^ i)
Next i

myKPCI.Write 3, CtlReg  ' configure the 3 ports controlled at this register
' or substitute CtlReg with your value for your configuration

' now that configuration is done, enable other buttons
cmdReadC.Enabled = True
cmdPortB.Enabled = True

' for KPCI-PIO96 there are total of 4 groups
' Group 0: offsets of 0 through 3
' Group 1: offsets of 4 through 7
' Group 2: offsets of 8 through 11 (hex B)
' Group 3: offsets of 12 through 15 (hex C through F)
End Sub

Private Sub cmdInit_Click()
' in project references be sure to include
' the Keithley Digital IO Library
On Error GoTo WrongBoard
Set myKPCI = New KPCIPIO
myKPCI.OpenDevice (devNum.ListIndex)
' enable configure button
cmdConfigure.Enabled = True
Exit Sub  'bypass error handling
WrongBoard:
' could not create object
MsgBox "Could not create Object.  Is DriverLINX for KPCI-PIOxx installed?  Check the Device Number too.", vbCritical
Exit Sub
End Sub


Private Sub cmdPortB_Click()
' ERA-01 connects to port B
' write to port B to turn relays on or off
' port B is at offset of 1
'
Timer1.Interval = 750  ' three quarter second
Timer1.Enabled = True

End Sub

Private Sub cmdReadC_Click()
Label1.Caption = myKPCI.Read(2)  ' Port C is at offset of 2
End Sub

Private Sub Form_Load()
Form1.Caption = "Direct I/O COM object with KPCI-PIOxx boards"
' center the form
   With Form1
        ' Center the form on the screen
        .Left = (Screen.Width - .Width) / 2
        .Top = (Screen.Height - .Height) / 2
   End With
' populate combo box with legal device numbers
Dim i As Integer
For i = 0 To 5
devNum.AddItem Str(i), i
Next i
' set it equal to first entry
devNum.ListIndex = 0
End Sub

Private Sub Timer1_Timer()
' ERA-01 connects to port B
' write to port B to turn relays on or off
' port B is at offset of 1
'
Static i As Integer
myKPCI.Write 1, 2 ^ i  ' 2 raised to the power will walk the bits
Label2.Caption = "Bit # : " & Str(i) & " is at logic 1"
i = i + 1

If i = 8 Then
Timer1.Enabled = False
i = 0  ' reset static variable i to zero in case button is pushed again
' turn all relays off on exit
myKPCI.Write 1, 0
Label2.Caption = "done writing Port B"
End If
End Sub
